import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PageResizer;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;

public class test {

    public static void main(String[] args) throws Exception {

        String[] inputs = {
                "src/main/resources/pdf/cmp_add_pointer.pdf",
                "src/main/resources/pdf/cmp_inkAnnotation01.pdf",
                "src/main/resources/pdf/cmp_add_polygon_link.pdf",
        };

        String dest = "src/main/resources/pdf/resized_output.pdf";

        PdfDocument output = new PdfDocument(new PdfWriter(dest));

        PageResizer resizer = new PageResizer(
                PageSize.A4,
                PageResizer.ResizeType.MAINTAIN_ASPECT_RATIO
              //  PageResizer.ResizeType.DEFAULT
        );

        resizer.setHorizontalAnchorPoint(PageResizer.HorizontalAnchorPoint.CENTER);
        resizer.setVerticalAnchorPoint(PageResizer.VerticalAnchorPoint.CENTER);

        for (String src : inputs) {
            try (PdfDocument input = new PdfDocument(new PdfReader(src))) {

                int start = output.getNumberOfPages() + 1;

                input.copyPagesTo(1, input.getNumberOfPages(), output);

                int end = output.getNumberOfPages();

                for (int p = start; p <= end; p++) {
                    resizer.resize(output.getPage(p));
                }
            }
        }
        output.close();
    }
}