﻿using System;
using iText.Kernel.Geom;
using iText.Kernel.Pdf;

class Program
{
    static void Main(string[] args)
    {
        string[] inputs = {
            @"../../../pdf/cmp_add_pointer.pdf",
            @"../../../pdf/cmp_inkAnnotation01.pdf",
            @"../../../pdf/cmp_add_polygon_link.pdf"
        };

        string dest = @"../../../pdf/resized_output_dotnet.pdf";

        using (PdfDocument output = new PdfDocument(new PdfWriter(dest)))
        {
            PageResizer resizer = new PageResizer(
                PageSize.A4,
                PageResizer.ResizeType.MAINTAIN_ASPECT_RATIO
            );

            resizer.SetHorizontalAnchorPoint(PageResizer.HorizontalAnchorPoint.CENTER);
            resizer.SetVerticalAnchorPoint(PageResizer.VerticalAnchorPoint.CENTER);

            foreach (string src in inputs)
            {
                using (PdfDocument input = new PdfDocument(new PdfReader(src)))
                {
                    int start = output.GetNumberOfPages() + 1;
                    input.CopyPagesTo(1, input.GetNumberOfPages(), output);
                    int end = output.GetNumberOfPages();

                    for (int p = start; p <= end; p++)
                    {
                        resizer.Resize(output.GetPage(p));
                    }
                }
            }
        }
    }
}