import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

void main() => runApp(MyApp());

class MyApp extends StatelessWidget {
  static const platform = MethodChannel('flutter_pdf');

  Future<void> _generatePdf() async {
    try {
      final path = await platform.invokeMethod<String>('generatePdf');
      print('PDF created at: $path');
      _showDialog(path!);
    } catch (e) {
      print('Error: $e');
    }
  }

  void _showDialog(String path) {
    WidgetsBinding.instance.addPostFrameCallback((_) {
      showDialog(
        context: navigatorKey.currentContext!,
        builder: (_) => AlertDialog(
          title: Text("PDF Generated"),
          content: Text("Saved at:\n$path"),
          actions: [
            TextButton(child: Text("OK"), onPressed: () => Navigator.pop(navigatorKey.currentContext!))
          ],
        ),
      );
    });
  }

  static final navigatorKey = GlobalKey<NavigatorState>();

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      navigatorKey: navigatorKey,
      home: Scaffold(
        appBar: AppBar(title: Text("Flutter iText integration")),
        body: Center(
          child: ElevatedButton(
            onPressed: _generatePdf,
            child: Text("Generate PDF"),
          ),
        ),
      ),
    );
  }
}