package com.example.itextdemo;

import android.os.Bundle;
import io.flutter.embedding.android.FlutterActivity;
import io.flutter.plugin.common.MethodChannel;

import java.io.File;
import java.io.FileOutputStream;

import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Paragraph;

public class MainActivity extends FlutterActivity {
    private static final String CHANNEL = "flutter_pdf";

    @Override
    public void configureFlutterEngine(io.flutter.embedding.engine.FlutterEngine flutterEngine) {
        super.configureFlutterEngine(flutterEngine);

        new MethodChannel(flutterEngine.getDartExecutor().getBinaryMessenger(), CHANNEL)
                .setMethodCallHandler((call, result) -> {
                    if (call.method.equals("generatePdf")) {
                        try {
                            File file = new File(getCacheDir(), "sample_01.pdf");
                            PdfWriter writer = new PdfWriter(new FileOutputStream(file));
                            PdfDocument pdf = new PdfDocument(writer);
                            Document doc = new Document(pdf);
                            doc.add(new Paragraph("Hello from iText and Flutter!"));
                            doc.close();
                            result.success(file.getAbsolutePath());
                        } catch (Exception e) {
                            result.error("PDF_ERROR", e.getMessage(), null);
                        }
                    }
                });
    }
}