import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.licensing.base.LicenseKey;
import java.io.InputStream;

public class SampleCase {
    public static void loadLicenses() {
        try {
            // no full path as gradle resolves resources as resource name
            String[] licenseFiles = {
                    "<Enter License File here>",
                    "<Enter License File here>"
            };

            for (String license : licenseFiles) {
                InputStream stream = SampleCase.class.getClassLoader()
                        .getResourceAsStream(license);
                if (stream == null) {
                    throw new RuntimeException("Missing license file: " + license);
                }
                LicenseKey.loadLicenseFile(stream);
                System.out.println("Loaded license: " + license);


              //  PdfWriter writ = new PdfDocument(new PdfWriter("output.pdf"));
            //    new PdfDocument(writ).close();

            }

            System.out.println("All licenses loaded successfully!");
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("License loading failed", e);
        }
    }

    public static void main(String[] args) {
        loadLicenses();
    }
}